/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.forge;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.registries.ForgeRegistries;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_18_R2.CraftStatistic;
import org.bukkit.craftbukkit.v1_18_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_18_R2.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_18_R2.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.magmafoundation.magma.Magma;
import org.magmafoundation.magma.configuration.MagmaConfig;
import org.magmafoundation.magma.craftbukkit.entity.CraftCustomEntity;
import org.magmafoundation.magma.helpers.EnumJ17Helper;
import org.magmafoundation.magma.util.ResourceLocationUtil;

public class ForgeInject {
    public static BiMap<ResourceKey<LevelStem>, World.Environment> environments = HashBiMap.create((Map)ImmutableMap.builder().put((Object)LevelStem.f_63971_, (Object)World.Environment.NORMAL).put((Object)LevelStem.f_63972_, (Object)World.Environment.NETHER).put((Object)LevelStem.f_63973_, (Object)World.Environment.THE_END).build());
    public static final Map<Villager.Profession, ResourceLocation> PROFESSION_MAP = new ConcurrentHashMap<Villager.Profession, ResourceLocation>();
    public static final Map<net.minecraft.world.entity.EntityType<?>, String> ENTITY_TYPES = new ConcurrentHashMap();

    public static void init() {
        ForgeInject.debug("Injecting Forge Materials into Bukkit");
        ForgeInject.addForgeMaterials();
        ForgeInject.debug("Injecting Forge Enchantments into Bukkit");
        ForgeInject.addForgeEnchantments();
        ForgeInject.debug("Injecting Forge Potions into Bukkit");
        ForgeInject.addForgePotions();
        ForgeInject.debug("Injecting Forge Biomes into Bukkit");
        ForgeInject.addForgeBiomes();
        ForgeInject.debug("Injecting Forge Entities into Bukkit");
        ForgeInject.addForgeEntities();
        ForgeInject.debug("Injecting Forge VillagerProfessions into Bukkit");
        ForgeInject.addForgeVillagerProfessions();
        ForgeInject.debug("Injecting Forge statistics into bukkit");
        ForgeInject.addForgeStatistics();
        ForgeInject.debug("Injecting Forge into Bukkit: DONE");
        try {
            for (Field field : Registry.class.getFields()) {
                Object object;
                if (!Modifier.isStatic(field.getModifiers()) || !((object = field.get(null)) instanceof Registry.SimpleRegistry)) continue;
                Registry.SimpleRegistry registry = (Registry.SimpleRegistry)object;
                registry.reloader.run();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void debug(String message) {
        if (MagmaConfig.instance.debugPrintInjections.getValues().booleanValue()) {
            Magma.LOGGER.warn(message);
        } else {
            Magma.LOGGER.debug(message);
        }
    }

    private static void error(String message) {
        Magma.LOGGER.error(message);
    }

    private static void addForgeMaterials() {
        Material material;
        Item item;
        int ordinal = Material.values().length;
        ArrayList<Material> values = new ArrayList<Material>();
        int origin = ordinal;
        int blocks = 0;
        for (Map.Entry<ResourceKey<Block>, Block> entry : ForgeRegistries.BLOCKS.getEntries()) {
            ResourceLocation location = entry.getKey().m_135782_();
            if (location.m_135827_().equals("minecraft")) continue;
            String enumName = ResourceLocationUtil.standardize(location);
            Block block = entry.getValue();
            item = ForgeRegistries.ITEMS.getValue(location);
            try {
                material = Material.addMaterial(enumName, ordinal, CraftNamespacedKey.fromMinecraft(location), true, item != null && item != Items.f_41852_);
                if (material == null) {
                    Magma.LOGGER.warn("Could not inject block into Bukkit: " + enumName);
                    continue;
                }
                ++ordinal;
                values.add(material);
                ++blocks;
                CraftMagicNumbers.BLOCK_MATERIAL.put(block, material);
                CraftMagicNumbers.MATERIAL_BLOCK.put(material, block);
                ForgeInject.debug("Injecting Forge Blocks into Bukkit: " + material.name());
            }
            catch (Throwable e) {
                ForgeInject.error("Could not inject block into Bukkit: " + enumName + ". " + e.getMessage());
            }
        }
        ForgeInject.debug("Injecting Forge Blocks into Bukkit: DONE");
        int items = 0;
        for (Map.Entry<ResourceKey<Item>, Item> entry : ForgeRegistries.ITEMS.getEntries()) {
            ResourceLocation location = entry.getKey().m_135782_();
            if (location.m_135827_().equals("minecraft")) continue;
            String enumName = ResourceLocationUtil.standardize(location);
            item = entry.getValue();
            material = Material.getMaterial(enumName);
            if (material == null) {
                try {
                    material = Material.addMaterial(enumName, ordinal, CraftNamespacedKey.fromMinecraft(location), false, true);
                    if (material == null) {
                        Magma.LOGGER.warn("Could not inject item into Bukkit: " + enumName);
                        continue;
                    }
                    values.add(material);
                    ++ordinal;
                    ++items;
                    ForgeInject.debug("Injecting Forge Material into Bukkit: " + material.name());
                }
                catch (Throwable e) {
                    ForgeInject.error("Could not inject item into Bukkit: " + enumName + ". " + e.getMessage());
                }
            }
            CraftMagicNumbers.ITEM_MATERIAL.put(item, material);
            CraftMagicNumbers.MATERIAL_ITEM.put(material, item);
        }
        ForgeInject.debug("Injecting Forge Material into Bukkit: DONE");
        EnumJ17Helper.addEnums(Material.class, values);
        Magma.LOGGER.info("Injected {} modded materials ({} blocks, {} items)", (Object)(ordinal - origin), (Object)blocks, (Object)items);
    }

    private static void addForgeEnchantments() {
        ForgeRegistries.ENCHANTMENTS.getEntries().forEach(entry -> {
            CraftEnchantment enchantment = new CraftEnchantment((Enchantment)entry.getValue());
            if (!org.bukkit.enchantments.Enchantment.byKey.containsKey(enchantment.getKey()) || !org.bukkit.enchantments.Enchantment.byName.containsKey(enchantment.getName())) {
                org.bukkit.enchantments.Enchantment.byKey.put(enchantment.getKey(), enchantment);
                org.bukkit.enchantments.Enchantment.byName.put(enchantment.getName(), enchantment);
                ForgeInject.debug("Injecting Forge Enchantments into Bukkit: " + enchantment.getName());
            }
        });
        ForgeInject.debug("Injecting Forge Enchantments into Bukkit: DONE");
    }

    private static void addForgePotions() {
        PotionEffectType.startAcceptingRegistrations();
        ForgeRegistries.MOB_EFFECTS.getEntries().forEach(entry -> {
            CraftPotionEffectType pet = new CraftPotionEffectType((MobEffect)entry.getValue());
            if (pet == null) {
                return;
            }
            try {
                PotionEffectType.registerPotionEffectType(pet);
                ForgeInject.debug("Registering Forge Potion into Bukkit: " + pet.getName());
            }
            catch (IllegalStateException e) {
                ForgeInject.error("Could not register potion effect into Bukkit: " + pet.getName() + ". " + e.getMessage());
            }
        });
        PotionEffectType.stopAcceptingRegistrations();
        int ordinal = EntityType.values().length;
        ArrayList<PotionType> values = new ArrayList<PotionType>();
        HashBiMap newRegular = HashBiMap.create(CraftPotionUtil.regular);
        for (Map.Entry<ResourceKey<Potion>, Potion> entry2 : ForgeRegistries.POTIONS.getEntries()) {
            ResourceLocation location = entry2.getKey().m_135782_();
            if (location.m_135827_().equals("minecraft")) continue;
            String enumName = ResourceLocationUtil.standardize(location);
            Potion potion = entry2.getValue();
            MobEffectInstance effect = potion.m_43488_().isEmpty() ? null : (MobEffectInstance)potion.m_43488_().get(0);
            PotionEffectType type = effect == null ? null : PotionEffectType.getById(MobEffect.m_19459_((MobEffect)effect.m_19544_()));
            try {
                PotionType potionType = EnumJ17Helper.makeEnum(PotionType.class, enumName, ordinal, List.of(PotionEffectType.class, Boolean.TYPE, Boolean.TYPE), List.of(type, Boolean.valueOf(false), Boolean.valueOf(false)));
                ++ordinal;
                values.add(potionType);
                newRegular.put((Object)potionType, (Object)potion.getRegistryName().toString());
                ForgeInject.debug("Injecting Forge Potion into Bukkit: " + potionType.name());
            }
            catch (Throwable e) {
                ForgeInject.error("Could not inject potion into Bukkit: " + enumName + ". " + e.getMessage());
            }
        }
        CraftPotionUtil.regular = newRegular;
        EnumJ17Helper.addEnums(PotionType.class, values);
        ForgeInject.debug("Injecting Forge Potion into Bukkit: DONE");
    }

    private static void addForgeBiomes() {
        int ordinal = EntityType.values().length;
        ArrayList<Biome> values = new ArrayList<Biome>();
        for (Map.Entry<ResourceKey<net.minecraft.world.level.biome.Biome>, net.minecraft.world.level.biome.Biome> entry : ForgeRegistries.BIOMES.getEntries()) {
            ResourceLocation location = entry.getKey().m_135782_();
            if (location.m_135827_().equals("minecraft")) continue;
            String enumName = ResourceLocationUtil.standardize(location);
            try {
                Biome biome = EnumJ17Helper.makeEnum(Biome.class, enumName, ordinal, List.of(), List.of());
                ++ordinal;
                values.add(biome);
                ForgeInject.debug("Injecting Forge Biome into Bukkit: " + biome.name());
            }
            catch (Throwable e) {
                ForgeInject.error("Could not inject biome into Bukkit: " + enumName + ". " + e.getMessage());
            }
        }
        EnumJ17Helper.addEnums(Biome.class, values);
        ForgeInject.debug("Injecting Forge Biome into Bukkit: DONE");
    }

    private static void addForgeEntities() {
        int ordinal = EntityType.values().length;
        ArrayList<EntityType> values = new ArrayList<EntityType>();
        for (Map.Entry<ResourceKey<net.minecraft.world.entity.EntityType<?>>, net.minecraft.world.entity.EntityType<?>> entry : ForgeRegistries.ENTITIES.getEntries()) {
            ResourceLocation location = entry.getValue().getRegistryName();
            if (location.m_135827_().equals("minecraft")) continue;
            String enumName = ResourceLocationUtil.standardize(location);
            int typeId = enumName.hashCode();
            try {
                EntityType bukkitType = EnumJ17Helper.makeEnum(EntityType.class, enumName, ordinal, List.of(String.class, Class.class, Integer.TYPE, Boolean.TYPE), List.of(enumName.toLowerCase(), CraftCustomEntity.class, Integer.valueOf(typeId), Boolean.valueOf(false)));
                EntityType.NAME_MAP.put(enumName.toLowerCase(), bukkitType);
                EntityType.ID_MAP.put((short)typeId, bukkitType);
                ++ordinal;
                values.add(bukkitType);
                ENTITY_TYPES.put(entry.getValue(), enumName);
                ForgeInject.debug("Injecting Forge Entity into Bukkit: " + enumName);
            }
            catch (Throwable e) {
                ForgeInject.error("Could not inject entity into Bukkit: " + enumName + ". " + e.getMessage());
            }
        }
        EnumJ17Helper.addEnums(EntityType.class, values);
        ForgeInject.debug("Injecting Forge Entity into Bukkit: DONE");
    }

    private static void addForgeVillagerProfessions() {
        int ordinal = Villager.Profession.values().length;
        ArrayList<Villager.Profession> values = new ArrayList<Villager.Profession>();
        for (Map.Entry<ResourceKey<VillagerProfession>, VillagerProfession> entry : ForgeRegistries.PROFESSIONS.getEntries()) {
            ResourceLocation location = entry.getKey().m_135782_();
            if (location.m_135827_().equals("minecraft")) continue;
            String enumName = ResourceLocationUtil.standardize(location);
            try {
                Villager.Profession profession = EnumJ17Helper.makeEnum(Villager.Profession.class, enumName, ordinal, List.of(), List.of());
                values.add(profession);
                ++ordinal;
                PROFESSION_MAP.put(profession, location);
                ForgeInject.debug("Injecting Forge VillagerProfession into Bukkit: " + profession.name());
            }
            catch (Throwable e) {
                ForgeInject.error("Could not inject villager profession into Bukkit: " + enumName + ". " + e.getMessage());
            }
        }
        EnumJ17Helper.addEnums(Villager.Profession.class, values);
        ForgeInject.debug("Injecting Forge VillagerProfession into Bukkit: DONE");
    }

    public static void addForgeEnvironment(net.minecraft.core.Registry<LevelStem> registry) {
        int ordinal = World.Environment.values().length;
        ArrayList<World.Environment> values = new ArrayList<World.Environment>();
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            World.Environment environment = (World.Environment)((Object)environments.get((Object)key));
            if (environment != null) continue;
            String enumName = ResourceLocationUtil.standardize(key.m_135782_());
            environment = EnumJ17Helper.makeEnum(World.Environment.class, enumName, ordinal, List.of(Integer.TYPE), List.of(Integer.valueOf(ordinal - 1)));
            values.add(environment);
            environments.put((Object)key, (Object)environment);
            ForgeInject.debug(String.format("Injected new Forge DimensionType %s.", new Object[]{environment}));
            ++ordinal;
        }
        EnumJ17Helper.addEnums(World.Environment.class, values);
    }

    public static void addForgeStatistics() {
        ArrayList<Statistic> values = new ArrayList<Statistic>();
        HashBiMap statistics = HashBiMap.create(CraftStatistic.statistics);
        int ordinal = Statistic.values().length;
        for (Map.Entry entry : net.minecraft.core.Registry.f_122832_.m_6579_()) {
            ResourceLocation resourceLocation = ((ResourceKey)entry.getKey()).m_135782_();
            assert (resourceLocation != null);
            if (resourceLocation.m_135827_().equals("minecraft")) continue;
            String name = ResourceLocationUtil.standardize(resourceLocation);
            try {
                Statistic statistic = EnumJ17Helper.makeEnum(Statistic.class, name, ordinal, List.of(), List.of());
                values.add(statistic);
                statistics.put((Object)resourceLocation, (Object)statistic);
                ForgeInject.debug("Injected Forge Statistic into Bukkit: " + statistic.name());
            }
            catch (Throwable e) {
                ForgeInject.error("Could not inject statistic into Bukkit: " + name + ". " + e.getMessage());
            }
        }
        EnumJ17Helper.addEnums(Statistic.class, values);
        CraftStatistic.statistics = statistics;
        ForgeInject.debug("Injecting Forge Statistic into Bukkit: DONE");
    }
}

